/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.livingthings.config.entity.LionConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.entity.misc.IGenderedMob;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import com.tristankechlo.livingthings.util.MinecraftTags;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class LionEntity
extends Animal
implements NeutralMob,
IMobVariants,
IGenderedMob,
ILexiconEntry {
    private static final EntityDataAccessor<Boolean> MALE = SynchedEntityData.m_135353_(LionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> LION_VARIANT = SynchedEntityData.m_135353_(LionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final UniformInt rangedInteger = TimeUtil.m_145020_((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public LionEntity(EntityType<? extends LionEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static boolean checkLionSpawnRules(EntityType<LionEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.LION_SPAWNABLE_ON) && LionEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entityIn) {
        LionEntity entityChild = (LionEntity)ModEntityTypes.LION.get().m_20615_(this.m_9236_());
        entityChild.setGender(LionEntity.getWeightedRandomGender(this.f_19796_));
        entityChild.setVariant(this.getVariantFromParents((AgeableMob)this, entityIn));
        return entityChild;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.setGender(LionEntity.getWeightedRandomGender(this.f_19796_));
        int color1Weight = (Integer)LionConfig.get().color1Weight.get();
        int colorWhiteWeight = (Integer)LionConfig.get().colorWhiteWeight.get();
        byte variant = this.getRandomVariant(this.f_19796_, new byte[]{0, 1}, new int[]{color1Weight, colorWhiteWeight});
        this.setVariant(variant);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static IGenderedMob.Gender getWeightedRandomGender(RandomSource random) {
        int maleWeight = (Integer)LionConfig.get().maleWeight.get();
        int femaleWeight = (Integer)LionConfig.get().femaleWeight.get();
        if (maleWeight <= 0 && femaleWeight <= 0) {
            return random.m_188499_() ? IGenderedMob.Gender.MALE : IGenderedMob.Gender.FEMALE;
        }
        Optional gender = WeightedRandom.m_216822_((RandomSource)random, (List)ImmutableList.of((Object)new IGenderedMob.WeightedGender(Math.max(0, maleWeight), IGenderedMob.Gender.MALE), (Object)new IGenderedMob.WeightedGender(Math.max(0, femaleWeight), IGenderedMob.Gender.FEMALE)));
        return ((IGenderedMob.WeightedGender)gender.get()).gender;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, LionConfig.health()).m_22268_(Attributes.f_22279_, LionConfig.movementSpeed()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, LionConfig.attackDamage());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BetterMeleeAttackGoal((PathfinderMob)this, 1.1, false, LionConfig::canAttack){

            public double m_6639_(LivingEntity attackTarget) {
                return this.f_25540_.m_20205_() * 1.8f * this.f_25540_.m_20205_() * 1.8f + attackTarget.m_20205_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 0.95));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 7.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, null));
        this.f_21346_.m_25352_(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MALE, (Object)false);
        this.f_19804_.m_135372_(LION_VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getGender() == IGenderedMob.Gender.MALE) {
            compound.m_128379_("IsMale", true);
        }
        compound.m_128344_("LionVariant", this.getVariant());
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128471_("IsMale")) {
            this.setGender(IGenderedMob.Gender.MALE);
        } else {
            this.setGender(IGenderedMob.Gender.FEMALE);
        }
        this.setVariant(compound.m_128445_("LionVariant"));
        this.m_147285_(this.m_9236_(), compound);
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof LionEntity) {
            LionEntity otherLion = (LionEntity)otherAnimal;
            if (this.getGender() != otherLion.getGender()) {
                return this.m_27593_() && otherLion.m_27593_();
            }
        }
        return false;
    }

    protected float m_6108_() {
        return 0.85f;
    }

    public boolean m_6898_(ItemStack stack) {
        boolean isMeat = stack.m_41720_().m_41472_() && (stack.m_41720_().m_41473_().m_38746_() || stack.m_204117_(MinecraftTags.MEAT));
        return stack.m_204117_(LivingThingsTags.LION_FOOD) || LionConfig.allowAllMeatAsFood() && isMeat;
    }

    protected SoundEvent m_7515_() {
        return ModSounds.LION_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return ModSounds.LION_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSounds.LION_DEATH.get();
    }

    public int m_5792_() {
        return LionConfig.maxSpawnedInChunk();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.96f;
    }

    @Override
    public IGenderedMob.Gender getGender() {
        if (((Boolean)this.m_20088_().m_135370_(MALE)).booleanValue()) {
            return IGenderedMob.Gender.MALE;
        }
        return IGenderedMob.Gender.FEMALE;
    }

    @Override
    public void setGender(IGenderedMob.Gender gender) {
        if (gender == IGenderedMob.Gender.MALE) {
            this.m_20088_().m_135381_(MALE, (Object)true);
        } else {
            this.m_20088_().m_135381_(MALE, (Object)false);
        }
    }

    @Override
    public byte getVariant() {
        return (Byte)this.m_20088_().m_135370_(LION_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.m_20088_().m_135381_(LION_VARIANT, (Object)variant);
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int time) {
        this.angerTime = time;
    }

    public UUID m_6120_() {
        return this.angerTarget;
    }

    public void m_6925_(UUID target) {
        this.angerTarget = target;
    }

    public void m_6825_() {
        this.m_7870_(rangedInteger.m_214085_(this.f_19796_));
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.LION;
    }
}

